package gov.va.med.mhv.sm.api.patient;

import gov.va.med.mhv.sm.api.exception.SMSException;
import gov.va.med.mhv.sm.api.transfer.MessagesTO;
import gov.va.med.mhv.sm.api.transfer.PatientMessageTO;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.springframework.stereotype.Service;

@Produces({"application/octet-stream","application/xml","application/json"})
@Consumes({"multipart/form-data","application/xml","application/json"})

@Service("messageApiService")
public interface MessageAPIService {

	@POST
	@Path("/message/")
	public PatientMessageTO sendMessage(PatientMessageTO message) throws SMSException;
	
	@POST
	@Path("/message/attach")
	public PatientMessageTO sendMessageWithAttachment( @Multipart(value = "message") PatientMessageTO message, List<Attachment> attachments ) throws SMSException;
	
	@POST
	@Path("/message/{messageId}")
	public Response deleteMessage(@javax.ws.rs.PathParam("messageId") Long messageId) throws SMSException;

	@POST
	@Path("/message/{messageId}/move/tofolder/{folderId}")
	public Response moveMessage(@javax.ws.rs.PathParam("messageId") Long messageId, @javax.ws.rs.PathParam("folderId") Long folderId) throws SMSException;
	
	@GET
	@Path("/message/{messageId}/attachment/{attachmentId}")
	public Response getMessageAttachment(@javax.ws.rs.PathParam("messageId") Long messageId, @javax.ws.rs.PathParam("attachmentId") Long attachmentId) throws SMSException; //MultipartBody
	
	@POST
	@Path("/message/{messageId}/reply")
	public PatientMessageTO replyMessage(@javax.ws.rs.PathParam("messageId") Long messageId, PatientMessageTO message) throws SMSException;
	
	@POST
	@Path("/message/{messageId}/reply/attach")
	public PatientMessageTO replyMessageWithAttachment(@javax.ws.rs.PathParam("messageId") Long messageId, @Multipart(value = "message") PatientMessageTO message, List<Attachment> attachments ) throws SMSException;
	
	@GET
	@Path("/message/{messageId}/read")
	public PatientMessageTO readMessage(@javax.ws.rs.PathParam("messageId") Long messageId) throws SMSException;
	
	@GET
	@Path("/message/{messageId}/history")
	public MessagesTO getMessageHistory( @javax.ws.rs.PathParam("messageId") Long messageId ) throws SMSException;

	@GET
	@Path("/message/{messageId}/replyhistory")
	public MessagesTO getReplyMessageHistory( @javax.ws.rs.PathParam("messageId") Long messageId ) throws SMSException;;	
	
	@POST
	@Path("/message/draft")
	public PatientMessageTO saveDraftMessage(PatientMessageTO message) throws SMSException;

	@POST
	@Path("/message/{messageId}/replydraft")
	public PatientMessageTO saveReplyDraft(@javax.ws.rs.PathParam("messageId") Long currentMessageId, PatientMessageTO message) throws SMSException;	
	
//	@GET
//	@Path("/message/category")
//	public MessageCategoryTypesTO getMessageCategoryTypes() throws SMSException;
	
}
